package gov.va.med.mhv.integration.phr.service;

/**
 * User: Rob Murtha
 */
public class QueryServiceResponse extends ServiceResponse {

    public static final String BLOCKED = "BLOCKED";

    private static final long serialVersionUID = -826318866220210961L;
    /** generated during the query */
    private long requestMsgCtrlId;

    private long responseMsgCtrlId; 

    /** set when an immediate response has been processed */    
    private long recordCount;

    public QueryServiceResponse(String status) {
        super(status);
    }

    public long getRequestMsgCtrlId() {
        return this.requestMsgCtrlId;
    }

    public void setRequestMsgCtrlId(long requestMsgCtrlId) {
        this.requestMsgCtrlId = requestMsgCtrlId;
    }

    /** set after an immediate response is processed during a synchronous call */
    public long getResponseMsgCtrlId() {
        return responseMsgCtrlId;
    }

    /** set after an immediate response is processed during a synchronous call */
    public void setResponseMsgCtrlId(long responseMsgCtrlId) {
        this.responseMsgCtrlId = responseMsgCtrlId;
    }

    /** set after an immediate response is processed during a synchronous call */
    public long getRecordCount() {
        return this.recordCount;
    }


    public void setRecordCount(long recordCount) {
        this.recordCount=recordCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof QueryServiceResponse)) return false;
        if (!super.equals(o)) return false;

        QueryServiceResponse that = (QueryServiceResponse) o;

        if (recordCount != that.recordCount) return false;
        if (requestMsgCtrlId != that.requestMsgCtrlId) return false;
        if (responseMsgCtrlId != that.responseMsgCtrlId) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int) (requestMsgCtrlId ^ (requestMsgCtrlId >>> 32));
        result = 31 * result + (int) (responseMsgCtrlId ^ (responseMsgCtrlId >>> 32));
        result = 31 * result + (int) (recordCount ^ (recordCount >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return  super.toString()+ " "+
                "QueryServiceResponse{" +
                "requestMsgCtrlId=" + requestMsgCtrlId +
                ", responseMsgCtrlId=" + responseMsgCtrlId +
                ", recordCount=" + recordCount +
                '}';
    }
}
